--------------------------------------------------------------------------
--This prefab file is for loading autogenerated Particle System prefabs
--------------------------------------------------------------------------

local ParticlesAutogenData = require "prefabs.particles_autogen_data"
local prefabutil = require "prefabs.prefabutil"
local soundutil = require "util.soundutil"


local function OnSetSpawnInstigator(inst, instigator)
	TheTrackers.DebugSpawnParticles(inst, instigator)
	local params = inst.fx_sound_params
	if params then
		inst.sound_handle = soundutil.PlaySoundData(inst, params, "particles_autogen", instigator)
		inst.fx_sound_params = nil
	end
end

local function StopSound(inst)
	soundutil.KillSound(inst, inst.sound_handle)
end

function MakeAutogenParticles(name, params, is_debug)
	local assets =
	{
		Asset("PKGREF", "scripts/prefabs/particles_autogen.lua"),
		Asset("PKGREF", "scripts/prefabs/particles_autogen_data.lua"),
	}
	if not is_debug then
		table.insert(assets, Asset("PKGREF", "scripts/prefabs/autogen/particles/".. name ..".lua"))
	end
	-- else: doesn't correspond to a real file.

	local prefabs = {}

	if params then
		prefabutil.CollectAssetsForParticleSystem(assets, params, is_debug)
	end

	local function fn(prefabname)
		local inst = CreateEntity()
		inst:SetPrefabName(prefabname)
		inst.entity:AddTransform()

		inst:AddTag("FX")
		inst:AddTag("NOCLICK")

		-- Prop particle systems aremade persistent on spawn
		inst.persists = false

		inst:AddComponent("particlesystem")
		inst.param_id = ""

		if name then
			inst.components.particlesystem:LoadParams(name)
		end

		if params and params.sound then
			inst.fx_sound_params = params.sound
			inst:ListenForEvent("onremove", StopSound)
			inst:ListenForEvent("particles_stopemit", StopSound)
		end

		inst.OnSetSpawnInstigator = OnSetSpawnInstigator

		return inst
	end

	return Prefab(name, fn, assets, prefabs)
end

local ret = {}

for name, params in pairs(ParticlesAutogenData) do
	ret[#ret + 1] = MakeAutogenParticles(name, params)
end

-- Dummy particle system so we can spawn a blank from the editor
ret[#ret+1] = MakeAutogenParticles("particlesystem", nil, true)

return table.unpack(ret)
